<?php
/*
  Plugin Name: WP Testimonials by MyThemeShop
  Plugin URI: https://mythemeshop.com/plugins/wp-testimonials/
  Description: WP Testimonials is the perfect WordPress plugin for displaying & managing testimonials about your product or service, with a fully customizable interface.
  Author: MyThemeShop
  Author URI: https://mythemeshop.com
  Version: 1.0.9
*/
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
define( 'MTS_TESTIMONIALS_VERSION', '1.0.9' );
define( 'MTS_TESTIMONIALS_PATH', dirname( __FILE__ ) );
define( 'MTS_TESTIMONIALS_ADMIN_PATH', MTS_TESTIMONIALS_PATH . '/admin' );
define( 'MTS_TESTIMONIALS_INCLUDES_PATH', MTS_TESTIMONIALS_PATH . '/includes' );
define( 'MTS_TESTIMONIALS_FOLDER', basename( MTS_TESTIMONIALS_PATH ) );
define( 'MTS_TESTIMONIALS_URL', plugins_url() . '/' . MTS_TESTIMONIALS_FOLDER );

//if ( is_admin() ) {
	require MTS_TESTIMONIALS_ADMIN_PATH . '/admin.php';

	$mts_testimonials_admin = new MTS_Testimonials_Admin();
//}

require MTS_TESTIMONIALS_INCLUDES_PATH . '/functions.php';
require MTS_TESTIMONIALS_INCLUDES_PATH . '/testimonials.class.php';
require MTS_TESTIMONIALS_INCLUDES_PATH . '/testimonials-widget.php';

$mts_testimonials = new MTS_Testimonials();
$mts_testimonials_shortcodes = new MTS_Testimonials_Shortcodes();
$mts_testimonials_shortcode_generator = new MTS_Testimonials_Shortcode_Generator();

register_activation_hook( __FILE__, array( $mts_testimonials, 'install' ) );
